//Obtiene proyectos
let proyectos
const bloquesLayout = [
    'g4x7',
    'g4x5',
    'g4x4',
    'g4x4',
    'g4x4',
    'g4x6',
    'g4x6',
]

const obtenerProyectos = async() => {
    try {
        const res = await fetch(blog_url + '/wp-json/wp/v2/proyectos?per_page=100&_embed');
        proyectos = await res.json();
        printProyectos();
        // console.log(proyectos);
    } catch (error) {
        // console.log(error);
    }
}
obtenerProyectos()

const creaProyecto = (producto, index, imagePreview, num) => (
    `<a href="${producto.link}" class="item ${bloquesLayout[num]}">
        <div class="contenedor-background">
            <img src="${imagePreview}" alt="">
        </div>
        <div class="contenedor-hover">
            <h4>${producto.title.rendered}</h4>
        </div>
        <div class="contenedor-titulo-mobile">
            <h4>${producto.title.rendered}</h4>
        </div>
    </a>`
)

const printProyectos = (proyectosFiltrados = null) => {

    if(!proyectosFiltrados){
        proyectosFiltrados = proyectos;
    }
    if(proyectosFiltrados){
        $('.contenedor-proyectos .main-container .contenedor-proyectos-grid').empty();
        let num = 0;
        proyectosFiltrados.map((producto, index) => {
            let imagePreview = '';
            if(producto._embedded['wp:featuredmedia']){
                imagePreview = producto._embedded['wp:featuredmedia'][0].media_details.sizes.medium_large.source_url;
            }
            if(num > (bloquesLayout.length - 1)){
                num = 0;
            }
            $('.contenedor-proyectos .main-container .contenedor-proyectos-grid').append(creaProyecto(producto, index, imagePreview, num));
            num++;
        })
    }
}

$('[data-filtro]').click((e) => {
    e.preventDefault();
    activeFiltro(e.currentTarget);
    filtraProyectos($(e.currentTarget).attr('data-filtro'))
});
const activeFiltro = (element) => {
    $('[data-filtro]').removeClass('active')
    $(element).addClass('active');
    drawFilter(element)
}

const filtraProyectos = (id) => {
    if(id == 0){
        printProyectos();
    }else{
        let filterProyectos = [];
        proyectos.map((proyecto, index) => {
            proyecto.categoria.map(categoria => {
                if(categoria == id){
                    filterProyectos = [...filterProyectos, proyecto]
                }
            })
        });
        printProyectos(filterProyectos);
    }
}
///////////////////////////////////////////////////
const drawFilter = (element) => {
    $('.contenedor-filtro .item').each((index, item) => {
        if(item == element){
            gsap.timeline().to(item.children[1].children[0].children[0], {
                duration: 0.3,
                stagger: 0.1,
                drawSVG: '100%'
            });
        }else{
            gsap.timeline().to(item.children[1].children[0].children[0], {
                duration: 0.3,
                stagger: 0.1,
                drawSVG: '0'
            });
        }
    })
}
const drawFilterInicial = () => {
    gsap.timeline().to(".contenedor-filtro .item.active .circle-draw", {
        duration: 0.3,
        stagger: 0.1,
        drawSVG: '100%'
    });
}
drawFilterInicial()
///////////////////////////////////////////////////