<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header(); 
?>


<?php the_post(); ?>

<?php
smk_get_template_part('template-parts/components/bloque-producto.php');
?>
<?php 
$posts = get_posts( array(
	'post_type' => 'product',
	'post_status' => 'publish',
	'posts_per_page'   => 4,
	'exclude' => [get_the_ID()],
	'orderby' => 'rand',
    'order'    => 'ASC'
) );
smk_get_template_part('template-parts/components/bloque-mas.php', array(
	"titulo" => 'Más productos',
	"items" => $posts
));
?>
<?php
get_footer();

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
